<?php
function changeStorageSettings()
{
   $sock = Login();
   checkActionAccess($sock, "write");

   $object = json_decode(file_get_contents("php://input"), true);
   checkReceivedFile($object);

   $arr = ParamGet($sock, "server");
   $arr = $arr->server;
   if ($object["archiveEncryption"] == 1) {
      if (!isset($arr->archiveEncryption)) {
         ParamSetInt($sock, "server.archiveEncryption", 1);
      }
      if (isset($object["password"])) {
         $password = $object["password"];
         ParamSetString($sock, "server.password", $object["password"]);
      }
   } else {
      if (isset($arr->archiveEncryption)) {
         $archiveEncryption = "server.archiveEncryption";
         ParamUnset($sock, $archiveEncryption);
      }
      $password = "server.password";
      ParamUnset($sock, $password);
   }

   if (isset($object["mdr"]) && $arr->mdr != $object["mdr"]) {
      $mdr = $object["mdr"];
      ParamSetInt($sock, "server.mdr", $mdr);
   }

   socket_close($sock);
}
function changeDisk()
{
   $sock = Login();
   checkActionAccess($sock, "write");

   $content_type = isset($_SERVER["CONTENT_TYPE"]) ? $_SERVER["CONTENT_TYPE"] : "";
   if (stripos($content_type, "application/json") === false) {
      throw new Exception("Content-Type must be application/json");
   }

   $body = file_get_contents("php://input");
   $object = json_decode($body, true);
   if (!is_array($object) || isContainNull($object)) {
      header("HTTP/1.1 400 Bad Request");
      die();
   }
   $id = $object["id"];
   $event = $object["status"] ? "mount" : "umount";

   $str = "DISK" . $id . $event;
   echo $str;
   Send($sock, $str);

   socket_close($sock);
}
function changeLongStorage()
{
   $sock = Login();
   checkActionAccess($sock, "write");

   $object = json_decode(file_get_contents("php://input"), true);
   checkReceivedFile($object);
   $storages = $object["storages"];
   $countStorage = $object["countStorage"];
   $arr = ParamGet($sock, "server");
   for ($i = 0; $i < 4; $i++) {
      ParamSetString($sock, "server.longTermCamMask.[$i]", $storages[$i]);
   }
   $disk["longTermHDNum"] = $arr->server->longTermHDNum;
   if ($disk["longTermHDNum"] != $countStorage) {
      ParamSetInt($sock, "server.longTermHDNum", $countStorage);
   }

   socket_close($sock);
}
